<?php

return [

    /*
    |--------------------------------------------------------------------------
    | ভ্যালিডেশন ভাষার লাইন
    |--------------------------------------------------------------------------
    |
    | নিম্নলিখিত ভাষার লাইনগুলো ভ্যালিডেশন এর জন্য ব্যবহার হয়।
    | কিছু রুলের একাধিক সংস্করণ থাকতে পারে। যেমন: size রুল।
    |
    */

    'accepted' => ':attribute গ্রহণ করতে হবে।',
    'accepted_if' => ':other যদি :value হয়, তখন :attribute গ্রহণ করতে হবে।',
    'active_url' => ':attribute একটি বৈধ URL নয়।',
    'after' => ':attribute অবশ্যই :date-এর পরের একটি তারিখ হতে হবে।',
    'after_or_equal' => ':attribute অবশ্যই :date-এর সমান বা পরের একটি তারিখ হতে হবে।',
    'alpha' => ':attribute শুধুমাত্র অক্ষর থাকতে হবে।',
    'alpha_dash' => ':attribute শুধুমাত্র অক্ষর, সংখ্যা, ড্যাশ এবং আন্ডারস্কোর থাকতে হবে।',
    'alpha_num' => ':attribute শুধুমাত্র অক্ষর এবং সংখ্যা থাকতে হবে।',
    'array' => ':attribute অবশ্যই একটি অ্যারে হতে হবে।',
    'ascii' => ':attribute শুধুমাত্র এক-বাইটের আলফানিউমেরিক অক্ষর এবং চিহ্ন থাকতে হবে।',
    'before' => ':attribute অবশ্যই :date-এর আগে একটি তারিখ হতে হবে।',
    'before_or_equal' => ':attribute অবশ্যই :date-এর সমান বা পূর্বের একটি তারিখ হতে হবে।',
    'between' => [
        'array' => ':attribute-এ :min থেকে :max আইটেম থাকতে হবে।',
        'file' => ':attribute :min থেকে :max কিলোবাইটের মধ্যে হতে হবে।',
        'numeric' => ':attribute অবশ্যই :min এবং :max এর মধ্যে হতে হবে।',
        'string' => ':attribute :min থেকে :max অক্ষরের মধ্যে হতে হবে।',
    ],
    'boolean' => ':attribute ফিল্ড অবশ্যই true বা false হতে হবে।',
    'confirmed' => ':attribute নিশ্চিতকরণ মেলছে না।',
    'current_password' => 'পাসওয়ার্ডটি সঠিক নয়।',
    'date' => ':attribute একটি বৈধ তারিখ নয়।',
    'date_equals' => ':attribute অবশ্যই :date সমান একটি তারিখ হতে হবে।',
    'date_format' => ':attribute :format ফরম্যাটের সাথে মেলে না।',
    'decimal' => ':attribute-এ :decimal দশমিক সংখ্যা থাকতে হবে।',
    'declined' => ':attribute প্রত্যাখ্যাত হতে হবে।',
    'declined_if' => ':other যদি :value হয়, তখন :attribute প্রত্যাখ্যাত হতে হবে।',
    'different' => ':attribute এবং :other অবশ্যই ভিন্ন হতে হবে।',
    'digits' => ':attribute অবশ্যই :digits সংখ্যার হতে হবে।',
    'digits_between' => ':attribute অবশ্যই :min থেকে :max সংখ্যার মধ্যে হতে হবে।',
    'dimensions' => ':attribute-এ অবৈধ ইমেজ মাত্রা আছে।',
    'distinct' => ':attribute ফিল্ডের পুনরাবৃত্তি মান আছে।',
    'doesnt_end_with' => ':attribute নিম্নলিখিতগুলির কোন একটি দিয়ে শেষ হতে পারবে না: :values।',
    'doesnt_start_with' => ':attribute নিম্নলিখিতগুলির কোন একটি দিয়ে শুরু হতে পারবে না: :values।',
    'email' => ':attribute অবশ্যই একটি বৈধ ইমেল ঠিকানা হতে হবে।',
    'ends_with' => ':attribute অবশ্যই নিম্নলিখিতগুলির কোন একটি দিয়ে শেষ হতে হবে: :values।',
    'enum' => 'নির্বাচিত :attribute অবৈধ।',
    'exists' => 'নির্বাচিত :attribute অবৈধ।',
    'file' => ':attribute অবশ্যই একটি ফাইল হতে হবে।',
    'filled' => ':attribute ফিল্ডে মান থাকতে হবে।',
    'gt' => [
        'array' => ':attribute-এ :value এর বেশি আইটেম থাকতে হবে।',
        'file' => ':attribute অবশ্যই :value কিলোবাইটের বেশি হতে হবে।',
        'numeric' => ':attribute অবশ্যই :value এর বেশি হতে হবে।',
        'string' => ':attribute অবশ্যই :value অক্ষরের বেশি হতে হবে।',
    ],
    'gte' => [
        'array' => ':attribute-এ :value বা তার বেশি আইটেম থাকতে হবে।',
        'file' => ':attribute অবশ্যই :value কিলোবাইটের সমান বা বেশি হতে হবে।',
        'numeric' => ':attribute অবশ্যই :value সমান বা বেশি হতে হবে।',
        'string' => ':attribute অবশ্যই :value অক্ষরের সমান বা বেশি হতে হবে।',
    ],
    'image' => ':attribute অবশ্যই একটি ইমেজ হতে হবে।',
    'in' => 'নির্বাচিত :attribute অবৈধ।',
    'in_array' => ':attribute ফিল্ড :other এ উপস্থিত নেই।',
    'integer' => ':attribute অবশ্যই একটি পূর্ণসংখ্যা হতে হবে।',
    'ip' => ':attribute অবশ্যই একটি বৈধ IP ঠিকানা হতে হবে।',
    'ipv4' => ':attribute অবশ্যই একটি বৈধ IPv4 ঠিকানা হতে হবে।',
    'ipv6' => ':attribute অবশ্যই একটি বৈধ IPv6 ঠিকানা হতে হবে।',
    'json' => ':attribute অবশ্যই একটি বৈধ JSON স্ট্রিং হতে হবে।',
    'lowercase' => ':attribute অবশ্যই ছোট অক্ষরে হতে হবে।',
    'lt' => [
        'array' => ':attribute-এ :value এর কম আইটেম থাকতে হবে।',
        'file' => ':attribute অবশ্যই :value কিলোবাইটের কম হতে হবে।',
        'numeric' => ':attribute অবশ্যই :value এর কম হতে হবে।',
        'string' => ':attribute অবশ্যই :value অক্ষরের কম হতে হবে।',
    ],
    'lte' => [
        'array' => ':attribute-এ :value এর বেশি আইটেম থাকতে পারবে না।',
        'file' => ':attribute অবশ্যই :value কিলোবাইটের কম বা সমান হতে হবে।',
        'numeric' => ':attribute অবশ্যই :value এর কম বা সমান হতে হবে।',
        'string' => ':attribute অবশ্যই :value অক্ষরের কম বা সমান হতে হবে।',
    ],
    'mac_address' => ':attribute অবশ্যই বৈধ MAC ঠিকানা হতে হবে।',
    'max' => [
        'array' => ':attribute-এ :max এর বেশি আইটেম থাকতে পারবে না।',
        'file' => ':attribute :max কিলোবাইটের বেশি হতে পারবে না।',
        'numeric' => ':attribute :max এর বেশি হতে পারবে না।',
        'string' => ':attribute :max অক্ষরের বেশি হতে পারবে না।',
    ],
    'max_digits' => ':attribute-এ :max সংখ্যার বেশি থাকতে পারবে না।',
    'mimes' => ':attribute অবশ্যই নিম্নলিখিত ধরনের ফাইল হতে হবে: :values।',
    'mimetypes' => ':attribute অবশ্যই নিম্নলিখিত ধরনের ফাইল হতে হবে: :values।',
    'min' => [
        'array' => ':attribute-এ অন্তত :min আইটেম থাকতে হবে।',
        'file' => ':attribute অন্তত :min কিলোবাইটের হতে হবে।',
        'numeric' => ':attribute অন্তত :min হতে হবে।',
        'string' => ':attribute অন্তত :min অক্ষরের হতে হবে।',
    ],
    'min_digits' => ':attribute-এ অন্তত :min সংখ্যা থাকতে হবে।',
    'multiple_of' => ':attribute অবশ্যই :value-এর গুণিতক হতে হবে।',
    'not_in' => 'নির্বাচিত :attribute অবৈধ।',
    'not_regex' => ':attribute ফরম্যাট অবৈধ।',
    'numeric' => ':attribute অবশ্যই একটি সংখ্যা হতে হবে।',
    'password' => [
        'letters' => ':attribute-এ অন্তত একটি অক্ষর থাকতে হবে।',
        'mixed' => ':attribute-এ অন্তত একটি বড় ও একটি ছোট অক্ষর থাকতে হবে।',
        'numbers' => ':attribute-এ অন্তত একটি সংখ্যা থাকতে হবে।',
        'symbols' => ':attribute-এ অন্তত একটি প্রতীক থাকতে হবে।',
        'uncompromised' => 'প্রদত্ত :attribute একটি ডেটা লিক-এ প্রকাশিত হয়েছে। ভিন্ন :attribute নির্বাচন করুন।',
    ],
    'present' => ':attribute ফিল্ড উপস্থিত থাকতে হবে।',
    'prohibited' => ':attribute ফিল্ড নিষিদ্ধ।',
    'prohibited_if' => ':other যদি :value হয়, তখন :attribute ফিল্ড নিষিদ্ধ।',
    'prohibited_unless' => ':other :values এর মধ্যে না থাকলে :attribute ফিল্ড নিষিদ্ধ।',
    'prohibits' => ':attribute ফিল্ড :other উপস্থিত থাকা নিষিদ্ধ করে।',
    'regex' => ':attribute ফরম্যাট অবৈধ।',
    'required' => ':attribute ফিল্ড প্রয়োজন।',
    'required_array_keys' => ':attribute ফিল্ডে নিম্নলিখিতগুলি থাকতে হবে: :values।',
    'required_if' => ':other যদি :value হয়, তখন :attribute ফিল্ড প্রয়োজন।',
    'required_if_accepted' => ':other গ্রহণ করা হলে :attribute প্রয়োজন।',
    'required_unless' => ':other :values এর মধ্যে না থাকলে :attribute প্রয়োজন।',
    'required_with' => ':values উপস্থিত থাকলে :attribute প্রয়োজন।',
    'required_with_all' => ':values উপস্থিত থাকলে :attribute প্রয়োজন।',
    'required_without' => ':values উপস্থিত না থাকলে :attribute প্রয়োজন।',
    'required_without_all' => ':values এর মধ্যে কোনটি উপস্থিত না থাকলে :attribute প্রয়োজন',
];