<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('payments', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('business_id')->default(1);
            $table->unsignedBigInteger('location_id')->default(1);
            $table->unsignedBigInteger('contact_id')->nullable();
            $table->unsignedBigInteger('transaction_id')->nullable();
            $table->unsignedBigInteger('staff_name')->nullable();
            $table->string('type');
            $table->string('payment_type');
            $table->decimal('amount');
            $table->decimal('previews_due')->nullable();
            $table->decimal('hand_cash')->nullable();
            $table->dateTime('date')->nullable();
            $table->boolean('is_open')->default(false);
            $table->text('note')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('payments');
    }
};
